<?php

require_once DOL_DOCUMENT_ROOT . '/product/stock/class/entrepot.class.php';

class InterfaceTriggerExpense_report_location
{
    public $family = 'expensereport';
    public $description = "Auto-fill Business Location with warehouse name";
    public $version = '1.0';
    public $picto = 'trip';

    public function runTrigger($action, $object, $user, $langs, $conf)
    {
        global $db;

        // Log trigger activation
        dol_syslog("Trigger expense_report_location fired for action: $action", LOG_DEBUG);

        // Only run on expense report creation
        if ($action === 'EXPENSE_REPORT_CREATE' && !empty($user->fk_warehouse)) {
            $warehouse = new Entrepot($db);
            if ($warehouse->fetch($user->fk_warehouse) > 0) {
                // Set the business_location field to warehouse name (ref)
                $object->array_options['options_business_location'] = $warehouse->ref;
            } else {
                $object->array_options['options_business_location'] = 'Warehouse not found';
            }
        } else {
            $object->array_options['options_business_location'] = 'No warehouse assigned';
        }

        return 0;
    }
}