<?php
include_once DOL_DOCUMENT_ROOT . "/core/boxes/modules_boxes.php";

class expenseswidget extends ModeleBoxes
{
    public $boxcode    = "expenseswidget";
    public $boximg     = "fa-money-bill";
    public $boxlabel   = 'Expenses Widget';
    public $lang       = 'businessdashboard@businessdashboard';
    public $depends    = array('businessdashboard');
    public $widgettype = 'graph';

    public function __construct(DoliDB $db, $param = '')
    {
        parent::__construct($db, $param);
        $this->param = $param;
    }

    public function loadBox($max = 5)
    {
        global $langs, $user;

        // Skip entirely if module disabled or user lacks rights
        if (!isModEnabled('businessdashboard')) return;
        if (empty($user->rights->businessdashboard->VIEW_EXPENSES)) return;

        $this->info_box_head = array(
            'text'     => $langs->trans("Expenses Information"),
            'subpicto' => 'fa-money-bill',
        );
        $this->info_box_contents = array();

        // Demo values
        $date     = dol_print_date(dol_now(), 'day');
        $travel   = 10000;
        $supplies = 5000;
        $total    = $travel + $supplies;

        // Header row
        $this->info_box_contents[] = array(
            0 => array('td'=>'align="left"',  'text'=>$langs->trans("Date")),
            1 => array('td'=>'align="right"', 'text'=>$langs->trans("Travel")),
            2 => array('td'=>'align="right"', 'text'=>$langs->trans("Supplies")),
            3 => array('td'=>'align="right"', 'text'=>$langs->trans("Total"))
        );

        // Data row
        $this->info_box_contents[] = array(
            0 => array('td'=>'align="left"',  'text'=>$date),
            1 => array('td'=>'align="right"', 'text'=>number_format($travel,0,'.',',')),
            2 => array('td'=>'align="right"', 'text'=>number_format($supplies,0,'.',',')),
            3 => array('td'=>'align="right"', 'text'=>number_format($total,0,'.',','))
        );

        // Store demo chart data for showBox
        $this->chart_labels = ["Travel","Supplies"];
        $this->chart_values = [10000,5000];
    }

    public function showBox($head = null, $contents = null, $nooutput = 0)
    {
        // If no content (permissions missing), skip entirely
        if (empty($this->info_box_head) || empty($this->info_box_contents)) return '';

        // Render the table
        $out = parent::showBox(
            $head ?? $this->info_box_head,
            $contents ?? $this->info_box_contents,
            1
        );

        // Chart data
        $labels = json_encode($this->chart_labels ?? ["Travel","Supplies"]);
        $values = json_encode($this->chart_values ?? [10000,5000]);

        // Compact chart container
        $out .= '<div style="height:150px; width:100%;"><canvas id="expensesChart"></canvas></div>';

        // Chart.js script
        $out .= "
        <script src=\"https://cdn.jsdelivr.net/npm/chart.js\"></script>
        <script>
        new Chart(document.getElementById('expensesChart'), {
            type: 'doughnut',
            data: {
                labels: $labels,
                datasets: [{
                    data: $values,
                    backgroundColor: ['#E91E63','#03A9F4']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    title: { display: true, text: 'Expense Breakdown' },
                    legend: { display: true }
                },
                cutout: '60%'
            }
        });
        </script>
        ";

        if (empty($nooutput)) print $out;
        return $out;
    }
}