<?php
header('Content-Type: text/html; charset=UTF-8'); // ✅ This forces UTF-8 encoding
require '../../main.inc.php'; // Load Dolibarr core
/*
 * Security check
 */
if (!isModEnabled('dashboardreports')) {
    accessforbidden('Module not enabled');
}
if (empty($user->rights->dashboardreports->read)) {
    accessforbidden('You do not have permission to access Dashboard Reports');
}

require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';

$langs->load("pulseiq"); // Optional: load custom language file if needed

llxHeader('', 'PulseIQ Dashboard'); // Page header

print load_fiche_titre('PulseIQ: Insight, Forecast & Alert System'); // Title bar

// Include the dashboard logic
include_once DOL_DOCUMENT_ROOT . '/custom/dashboardreports/pulseiq_dashboard.php';

llxFooter(); // Page footer