<?php
require_once '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

global $db, $user;

$sell_update_value = GETPOST('updatecostprice', 'alpha'); // Reuse same input field
$toselect = GETPOST('toselect', 'array');

if (empty($sell_update_value) || empty($toselect)) {
    setEventMessages('Missing value or selection.', null, 'warnings');
} else {
    $is_percentage = false;
    $rate = 0;

    if (strpos($sell_update_value, '%') !== false) {
        $is_percentage = true;
        $rate = floatval(str_replace('%', '', $sell_update_value));
        if (strpos($sell_update_value, '-') !== false) {
            $rate = -abs($rate);
        }
    } else {
        $rate = floatval($sell_update_value);
    }

    $nbok = 0;
    foreach ($toselect as $id) {
        $product = new Product($db);
        if ($product->fetch($id) > 0) {
            $old_ttc = $product->price_ttc;
            $tva_tx = isset($product->tva_tx) ? floatval($product->tva_tx) : 0;

            // Calculate new TTC price
            $new_ttc = $is_percentage ? $old_ttc * (1 + ($rate / 100)) : $old_ttc + $rate;
            if ($new_ttc < 0) $new_ttc = 0;

            // Format TTC to 2 decimal places
            $new_ttc = number_format($new_ttc, 2, '.', '');

            // Calculate HT from TTC
            if ($tva_tx <= 0) {
                $new_ht = $new_ttc;
            } else {
                $new_ht = $new_ttc / (1 + ($tva_tx / 100));
            }

            // Format HT to 2 decimal places
            $new_ht = number_format($new_ht, 2, '.', '');

            // Update both price fields
            $sql = "UPDATE ".MAIN_DB_PREFIX."product 
                    SET price = ".$new_ht.", 
                        price_ttc = ".$new_ttc.", 
                        fk_user_modif = ".$user->id." 
                    WHERE rowid = ".$id;

            if ($db->query($sql)) {
                $nbok++;
            }
        }
    }

    setEventMessages("$nbok product(s) updated using TTC.", null, 'mesgs');
}